/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.androidtools;

import com.android.tools.build.bundletool.androidtools.CommandExecutor;
import com.android.tools.build.bundletool.androidtools.DefaultCommandExecutor;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;

public interface P7ZipCommand {
    public void compress(Path var1, Path var2);

    public static P7ZipCommand defaultP7ZipCommand(Path p7zipExecutable, int numThreads) {
        return (outputPath, inputDirectoryPath) -> {
            ImmutableList<String> command = ImmutableList.of(p7zipExecutable.toString(), "a", "-tzip", "-mtc=off", "-mx=9", String.format("-mmt=%d", numThreads), "-bso0", "-bsp0", "-r", outputPath.toAbsolutePath().normalize().toString(), String.join((CharSequence)File.separator, inputDirectoryPath.toAbsolutePath().normalize().toString(), "*"));
            new DefaultCommandExecutor().execute(command, CommandExecutor.CommandOptions.builder().setTimeout(Duration.ofMinutes(10L)).build());
        };
    }
}

